/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.configuration;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.configuration.adapter.ConfigurationAdapter;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.CommentedConfigurationNode;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.ConfigurationNode;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.loader.ConfigurationLoader;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.serialize.SerializationException;
import org.jetbrains.annotations.Nullable;

public class ImpactorConfigurationAdapter
implements ConfigurationAdapter {
    private final Path path;
    private CommentedConfigurationNode root;

    public ImpactorConfigurationAdapter(Path path, @Nullable Supplier<InputStream> supplier) {
        this.path = path;
        this.createConfigIfMissing(supplier);
        this.reload();
    }

    private void createConfigIfMissing(@Nullable Supplier<InputStream> supplier) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                this.createDirectoriesIfNotExists(this.path.getParent());
                if (supplier != null) {
                    Files.copy(supplier.get(), this.path, new CopyOption[0]);
                } else {
                    Files.createFile(this.path, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void createDirectoriesIfNotExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || Files.isSymbolicLink(path))) {
            return;
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    private ConfigurationLoader<? extends CommentedConfigurationNode> createLoader(Path path) {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(path)).build();
    }

    @Override
    public void reload() {
        ConfigurationLoader<? extends CommentedConfigurationNode> loader = this.createLoader(this.path);
        try {
            this.root = loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CommentedConfigurationNode resolvePath(String path) {
        if (this.root == null) {
            throw new RuntimeException("Config is not loaded.");
        }
        return (CommentedConfigurationNode)this.root.node(Splitter.on((char)'.').splitToList((CharSequence)path).toArray());
    }

    @Override
    public String getString(String path, String def) {
        return this.resolvePath(path).getString(def);
    }

    @Override
    public int getInteger(String path, int def) {
        return this.resolvePath(path).getInt(def);
    }

    @Override
    public long getLong(String path, long def) {
        return this.resolvePath(path).getLong(def);
    }

    @Override
    public double getDouble(String path, double def) {
        return this.resolvePath(path).getDouble(def);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.resolvePath(path).getBoolean(def);
    }

    @Override
    public List<String> getStringList(String path, List<String> def) {
        CommentedConfigurationNode node = this.resolvePath(path);
        if (node.virtual()) {
            return def;
        }
        try {
            return node.getList(String.class);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    @Override
    public List<String> getKeys(String path, List<String> def) {
        CommentedConfigurationNode node = this.resolvePath(path);
        if (node.virtual()) {
            return def;
        }
        return node.childrenMap().keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getStringMap(String path, Map<String, String> def) {
        Map m;
        CommentedConfigurationNode node = this.resolvePath(path);
        if (node.virtual()) {
            return def;
        }
        try {
            m = Optional.ofNullable(node.get(new TypeToken<Map<String, String>>(this){})).orElse(Collections.emptyMap());
        }
        catch (SerializationException e) {
            e.printStackTrace();
            m = Collections.emptyMap();
        }
        return m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public ConfigurationNode getNode(String path) {
        return this.resolvePath(path);
    }

    @Override
    public List<? extends ConfigurationNode> getNodeList(String path) {
        CommentedConfigurationNode node = this.resolvePath(path);
        if (node.virtual() || !node.isList()) {
            return Lists.newArrayList();
        }
        return node.childrenList();
    }
}

